/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

#ifndef __COM_APPLICATION_H__
#define __COM_APPLICATION_H__

//----------------------------------------------------------------------------------------------------------------------------------
	/*	25-Jun-1999
		Please change the path for ProD.tlb appropriately. It is available in the
		"Program" folder, where you have installed your ProD.
	*/

#import "C:\Program Files\PTC\ProDESKTOP 2001\Program\ProD.tlb" raw_interfaces_only, named_guids

using namespace ProDESKTOPLib;
//----------------------------------------------------------------------------------------------------------------------------------

HRESULT GetActivePartWorkplaneSketch(IPartDocument **activePart,
									IGraphicDocument **activeGraphicDoc,
									IWorkplane **activeWorkplane,
									ISketch **activeSketch);

HRESULT  GetProDESKTOPApplication(IApplication **ProDESKTOPApp);

HRESULT  RunProDESKTOP(IApplication **app);

HRESULT  CloseProDESKTOP();

HRESULT NewPart(IPartDocument **retval);

HRESULT CreateLine(double startX, double startY, double endX, double endY, ILine **dCurve1);

HRESULT CreateExtrusion(ISketch *pSketch, double distanceAbove, int distanceBelow, double taperAngle, int side,
						long materialStatus, CString extrusionName, IExtrusion **pExtrusion);

HRESULT ConstantRadiusBlending(ISet *pedge, VARIANT_BOOL bChamfer, VARIANT_BOOL bFlipped, VARIANT_BOOL bPropagate,
						VARIANT_BOOL bSmoothVariation, VARIANT_BOOL bGroupEdges, double radius,CString blendName,IBlend **pBlend);

HRESULT CreateISection(double length, double verticalThickness, double horizontalThickness, double width,
						double extrusionHeight, double blendRadius, ISet **dObjectSet1);

//----------------------------------------------------------------------------------------------------------------------------------

#define CAST(cls, obj) \
	CastInterface<cls>(obj,IID_##cls) \

template <class T> 
T *CastInterface(IDispatch *disp, GUID iid)
{
	void *pUnk;
	HRESULT hr = disp->QueryInterface(iid, (void **)&pUnk);
	VERIFY(!hr);
	return (T *)pUnk;
}

#define GetCLASS(cls) \
	GetFormalClass<I##cls##Class>(IID_I##cls##Class, #cls) \

template <class T>
T *GetFormalClass(GUID iid, CString clsName)
{
	IDispatch *disp = NULL;
	HRESULT hr = pdApp->GetClass(clsName.AllocSysString(), &disp);

	T *thisCls = NULL;
	hr = disp->QueryInterface(iid, (void **)&thisCls);
	if (FAILED(hr) || !thisCls) {
		AfxMessageBox("QueryInterface Failed");
		return NULL;
	}
	return thisCls;
}

//----------------------------------------------------------------------------------------------------------------------------------

#define START_METHOD(method) \
	try { \
		TRACE1("Calling Function %s \n", method); \
	
#define END_METHOD(method) \
	}  \
	catch (COleException *e) { \
		const SCODE code = e->m_sc; \
		e->Delete(); \
		return code; \
	} \
	return NOERROR; \

#define CHECK_RETURN_STATUS(hr) \
	if (FAILED(hr)) { \
	ASSERT(FALSE); \
	AfxThrowOleException(hr); \
	} \

#define CHECK_VAR_STATUS(var) \
	if (!var) { \
	ASSERT(FALSE); \
	AfxThrowOleException(E_FAIL); \
	} \

#define CHECK_RETURN_AND_VAR_STATUS(hr, var) \
	CHECK_RETURN_STATUS(hr) \
	CHECK_VAR_STATUS(var) \

#endif	// __COM_APPLICATION_H__
